<?php
  // Export CSV
  function export_user_csv() {
    global $wpdb;
    $file = 'user_subscriber';
    $results = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}user_subscriber;",ARRAY_A);

    if (empty($results)) {
      return;
    }
    $csv_output = '"'.implode('","',array_keys($results[0])).'",'."\n";;
    foreach ($results as $row) {
      $csv_output .= '"'.implode('","',$row).'",'."\n";
    }
    $csv_output .= "\n";
    

    $filename = $file."_".date("Y-m-d",time());
    
    ob_clean();
    header( 'Pragma: public' );
    header( 'Expires: 0' );
    header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
    header( 'Cache-Control: private', false );
    header( 'Content-Type: text/csv' );
    header("Content-Disposition: attachment;filename=".$filename.".csv");
    
    if ( isset( $results['0'] ) ) {
        $fp = fopen( 'php://output', 'w' );
        fputs($fp, $bom =( chr(0xEF) . chr(0xBB) . chr(0xBF) ));
        fputcsv( $fp, array_keys( $results['0'] ) );
        foreach ( $results AS $values ) {
            fputcsv( $fp, $values );
        }
        fclose( $fp );
    }
    ob_flush();

    // header('Content-Encoding: UTF-8');
    // header('Content-Type: text/csv; charset=UTF-8');
    // header("Content-Disposition: csv" . date("Y-m-d") . ".csv");
    // header("Content-Disposition: filename=".$filename.".csv");
    // echo "\xEF\xBB\xBF"; // UTF-8 BOM
    
    // header("Content-Type: application/vnd.ms-excel");
    // header("Content-Disposition: attachment; filename=\"$filename\".xls");
    // echo $csv_output;
    exit;
  }
  add_action( 'admin_post_export_user_csv', 'export_user_csv' );
  add_action( 'admin_post_nopriv_export_user_csv', 'export_user_csv' );

?>