<?php
/*
Plugin Name: User Subscriber
Description: User Subscriber
Plugin URI: 
Author URI: 
Author: Thawatchai Khuansombat
License: Public Domain
Version: 1.1
*/

/**
 * PART 1. Defining Custom Database Table
 * ============================================================================
 *
 * In this part you are going to define custom database table,
 * create it, update, and fill with some dummy data
 *
 * http://codex.wordpress.org/Creating_Tables_with_Plugins
 *
 * In case your are developing and want to check plugin use:
 *
 * DROP TABLE IF EXISTS wp_cte;
 * DELETE FROM wp_options WHERE option_name = 'install_demo_data';
 *
 * to drop table and option
 */

/**
 * $user_subscriber_table_version - holds current database version
 * and used on plugin update to sync database tables
 */
global $user_subscriber_table_version;
$user_subscriber_table_version = '1.0'; // version changed from 1.0 to 1.1

/**
 * register_activation_hook implementation
 *
 * will be called when user activates plugin first time
 * must create needed database tables
 */
function user_subscriber_table_install()
{
    global $wpdb;
    global $user_subscriber_table_version;

    $table_name = $wpdb->prefix . 'user_subscriber'; // do not forget about tables prefix

    // sql to create your table
    // NOTICE that:
    // 1. each field MUST be in separate line
    // 2. There must be two spaces between PRIMARY KEY and its name
    //    Like this: PRIMARY KEY[space][space](id)
    // otherwise dbDelta will not work
    $sql = "CREATE TABLE " . $table_name . " (
      id int(11) NOT NULL AUTO_INCREMENT,
      email VARCHAR(100) NOT NULL,
      create_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (id)
    );";

    // we do not execute sql directly
    // we are calling dbDelta which cant migrate database
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);

    // save current database version for later use (on upgrade)
    add_option('user_subscriber_table_version', $user_subscriber_table_version);

    /**
     * [OPTIONAL] Example of updating to 1.1 version
     *
     * If you develop new version of plugin
     * just increment $user_subscriber_table_version variable
     * and add following block of code
     *
     * must be repeated for each new version
     * in version 1.1 we change email field
     * to contain 200 chars rather 100 in version 1.0
     * and again we are not executing sql
     * we are using dbDelta to migrate table changes
     */
    $installed_ver = get_option('user_subscriber_table_version');
    if ($installed_ver != $user_subscriber_table_version) {
        $sql = "CREATE TABLE " . $table_name . " (
          id int(11) NOT NULL AUTO_INCREMENT,
          email VARCHAR(200) NOT NULL,
          create_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
          PRIMARY KEY (id)
        );";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        // notice that we are updating option, rather than adding it
        update_option('user_subscriber_table_version', $user_subscriber_table_version);
    }
}

register_activation_hook(__FILE__, 'user_subscriber_table_install');

/**
 * register_activation_hook implementation
 *
 * [OPTIONAL]
 * additional implementation of register_activation_hook
 * to insert some dummy data
 */
function install_demo_data()
{
    global $wpdb;

    $table_name = $wpdb->prefix . 'user_subscriber'; // do not forget about tables prefix

    $wpdb->insert($table_name, array(
			'email' => 'alex@example.com',
    ));
    // $wpdb->insert($table_name, array(
	// 		'name' => 'Maria',
	// 		'phone' => '08345834',
	// 		'email' => 'maria@example.com',
	// 		'message' => 'test massage',
    //         'utm_source' => 'google ad',
    //         'utm_medium' => 'web site',
    //         'utm_campaign' => 'test campaign'
    // ));
}

register_activation_hook(__FILE__, 'install_demo_data');

/**
 * Trick to update plugin database, see docs
 */
function check_db_update()
{
    global $user_subscriber_table_version;
    if (get_site_option('user_subscriber_table_version') != $user_subscriber_table_version) {
        user_subscriber_table_install();
    }
}

add_action('plugins_loaded', 'check_db_update');


function menu_page(){
  add_menu_page( 'User Subscriber', 'User Subscriber', 'edit_posts', 'user-subscriber', 'user_list_page' );
  // add_action( "load-$hook", 'add_options' );
}
add_action( 'admin_menu', 'menu_page' );

function user_list_page(){
?>
<!DOCTYPE html>
<head>
  <meta charset="UTF-8" />
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">
  <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
  <link rel="stylesheet"  href="https://cdn.datatables.net/1.10.22/css/jquery.dataTables.min.css">	
  <script src="https://cdn.datatables.net/1.10.22/js/jquery.dataTables.min.js" type="text/javascript"></script> 
  <link rel="stylesheet"  href="<?php echo get_template_directory_uri() ?>/DataTables/buttons.datatables.min.css">    
  <script src="<?php echo get_template_directory_uri() ?>/DataTables/dataTables.buttons.min.js" type="text/javascript"></script> 
  <script src="<?php echo get_template_directory_uri() ?>/DataTables/jszip.min.js" type="text/javascript"></script> 
  <script src="<?php echo get_template_directory_uri() ?>/DataTables/pdfmake.min.js" type="text/javascript"></script> 
  <script src="<?php echo get_template_directory_uri() ?>/DataTables/vfs_fonts.js" type="text/javascript"></script> 
  <script src="<?php echo get_template_directory_uri() ?>/DataTables/buttons.html5.min.js" type="text/javascript"></script> 
  <style>
    body {
        font-size: 12px !important;
    }
    .form-control:disabled, .form-control[readonly] {
        background-color: #fff;
        opacity: 1;
    }
    .container-fluid {
        padding-left: 0;
    }

    .dataTables_wrapper .dataTables_length select {
        padding: 0 24px 0 8px !important;
    }
  </style>
  <script>
    function deleteUser(id) {
      $.get(`<?php echo get_template_directory_uri() ?>/DataTables/delete.php?user-id=${id}`, function( data ) {
        $('#employeeTable').DataTable().draw();
      });
    }

    function fetchData(is_date_search, start_date, end_date) {
      $('#employeeTable').DataTable({
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
        processing: true,
        serverSide: true,
        dom: 'lBfrtip',
        buttons: [
          {
            extend: 'csvHtml5',
            title: 'user_subscriber',
            exportOptions: {
              modifier: {
                page: 'all',
                search: 'none'   
              }
            }
          },
          {
            extend: 'excelHtml5',
            title: 'user_subscriber',
            exportOptions: {
              modifier: {
                page: 'all',
                search: 'none'   
              }
            }
          }
        ],
        'ajax': {
          'url':'<?php echo get_template_directory_uri() ?>/DataTables/server.php',
          'data': function(data){
            data.is_date_search = is_date_search;
            data.start_date = start_date;
            data.end_date = end_date;
          }
        },
        "rowCallback": function(row, data, index){
          const id = data[0]
          $(row).append("<div style='padding:10px;'><button class='dt-button' onclick='deleteUser("+ id +")'>Delete</button></div>");
        }
      });
    }

    $(document).ready(function () {

        // jQuery("#add-user").click( function() {
		// 		jQuery.ajax({
		// 			type : "post",
		// 			dataType : "json",
		// 			url : ajaxurl,
		// 			data : {
		// 				action: "add_user_subscriber",
		// 				email: 'thawatchai.deartk@gmail.com',
		// 			},
		// 			success: function(response) {
		// 				console.log(response)
		// 				if(response.type == "success") {
		// 					alert(response.type)
		// 				}
		// 				else {
		// 					alert(response.massage)
		// 				}
		// 			}
		// 		})   
		// 	})
      $( ".datepicker" ).datepicker({
          "dateFormat": "yy-mm-dd"
      });

      fetchData('no');

      $('#search').click(function(){
      var start_date = $('#start_date').val();
      var end_date = $('#end_date').val();
      if(start_date != '' && end_date !='') {
        $('#employeeTable').DataTable().destroy();
        fetchData('yes', start_date, end_date );
      } else {
        alert("Both Date is Required");
      }
    }); 
    });
  </script>
</head>
<body>
<br>
<!-- <button id="add-user">Add</button> -->
<div class="container-fluid">
    <div class="row">
        <div class="col col-lg-6">
            <div class="input-group">
                <input type='text' readonly id='start_date' class="datepicker form-control form-control-sm" placeholder='From date'>
                <input type='text' readonly id='end_date' class="datepicker form-control form-control-sm" placeholder='To date'>
                <div class="input-group-append">
                    <button class="btn btn-secondary btn-sm" type="button" id="search">Search</button>
                </div>
            </div>
        </div>
    </div>
    
    <br>
    <div class="table-responsive">
      <table name="employeeTable" id="employeeTable" class="table table-striped table-bordered table-hover table-sm" >
        <thead>
          <tr>
            <!-- <th>Id</th> -->
            <th>Email</th>
            <!-- <th>Date</th> -->
          </tr>
        </thead>
      </table>
    </div>
  </div>
</body>
</html>
<?php
}

function dataTable()
{
  load_plugin_textdomain('user_subscriber', false, dirname(plugin_basename(__FILE__)));
}

add_action('init', 'dataTable');

require('export-csv.php');
require('export-pdf.php');
require('add-user.php');

