<?php
 
/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simply to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See http://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - http://datatables.net/license_mit
 */
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
 
// DB table to use
$table = 'wp_user_subscriber';
 
// Table's primary key
$primaryKey = 'id';
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
    // array( 'db' => 'id', 'dt' => 0 ),
    array( 'db' => 'email',  'dt' => 0 ),
    // array( 'db' => 'create_date',   'dt' => 1 ),
);
 
// SQL server connection information
// $sql_details = array(
//     'user' => 'onederco_admin',
//     'pass' => '"J;>[7Bd@9Fxf3N^',
//     'db'   => 'onederco_website',
//     'host' => 'localhost'
// );
$sql_details = array(
    'user' => 'root',
    'pass' => 'root',
    'db'   => 'local',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
require( './server-side/scripts/ssp.class.php' );
$whereResult = '';

if($_GET["is_date_search"] == "yes")
{
 $whereResult .= 'create_date BETWEEN "'.$_GET["start_date"].'" AND "'.$_GET["end_date"].' 23:59:59.997"';
}

echo json_encode(
    // SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns )
    SSP::complex ( $_GET, $sql_details, $table, $primaryKey, $columns, $whereResult, $whereAll='' )
);