<?php


add_filter('allowed_http_origins', 'add_allowed_origins');

function add_allowed_origins($origins) {
    $origins[] = 'http://localhost:3000';
    return $origins;
}

require_once( get_template_directory() . '/includes/url-header-login.php' );
require_once( get_template_directory() . '/includes/remove-menu.php' );
require_once( get_template_directory() . '/includes/signature.php' );
require_once( get_template_directory() . '/includes/acf-option-page.php' );
require_once( get_template_directory() . '/includes/send-contact-email.php' );


remove_filter( 'the_title' , 'wptexturize'  );



function custom_mtypes( $m ){
	$m['svg'] = 'image/svg+xml';
	$m['svgz'] = 'image/svg+xml';
	return $m;
}
add_filter( 'upload_mimes', 'custom_mtypes' );


function my_toolbars( $toolbars ) {
	$toolbars['Full'] = array();
	$toolbars['Full'][1] = array('formatselect', 'bold', 'italic', 'underline', 'forecolor', 'bullist', 'numlist', 'alignleft', 'aligncenter', 'alignright', 'alignjustify', 'link', 'unlink', 'hr', 'undo', 'redo', 'wp_adv' );
	$toolbars['Full'][2] = array('pastetext', 'removeformat', 'charmap', 'outdent', 'indent', 'wp_help' );
	// $toolbars['Full'][2] = array('styleselect', 'formatselect', 'fontselect', 'fontsizeselect', 'forecolor', 'pastetext', 'removeformat', 'charmap', 'outdent', 'indent', 'undo', 'redo', 'wp_help' );

	// remove the 'Basic' toolbar completely (if you want)
	// unset( $toolbars['Basic' ] );

	// return $toolbars - IMPORTANT!
	return $toolbars;
}
add_filter('acf/fields/wysiwyg/toolbars' , 'my_toolbars');

function override_mce_options($initArray){
	$initArray["selector"] = "#content, textarea[id*=wysiwyg-acf]";
	return $initArray;
}
add_filter('tiny_mce_before_init', 'override_mce_options');
?>